Getting Started
===============

The CallFire API provides a robust interface to control functionality available through the regular web interface,
plus some controls which are not otherwise accessible.

This library provides a set of PHP classes to interface with the
[CallFire API](http://www.callfire.com/api-documentation). Please refer to the
[API documentation](https://developers.callfire.com) for information
on finding your API credentials.

### Very basic example
This example demonstrates how to instantiate the REST API client, create
a request object, invoke a request, and then parse the response into
an easily-consumable form.  
```php
<?php
require 'vendor/autoload.php';

$client = CallFire\Api\Client::createClient("<api-login>", "<api-password>");

$request = $client->findVoiceBroadcasts();
$response = $client->request($request);

echo $response->getBody();
```

### Responses

Presently the SDK does not reliably parse the responses returned from the API.
This is something that is actively being worked on, and will be complete by
the time API 2.0 has stabilized. If you wish to attempt to use the response
parsing behaviour of this SDK, you can invoke Client::execute in place of
Client::request. ::execute automatically detects the type of the response that
will be returned from the API, based on the Swagger specification, and parses
the response into objects representing the structures also defined in the
Swagger specification.
